unit Unit1;
{==============================================================================}
{ This demo shows how to add pictures and horizontal lines into RichView.      }
{                                                                              }
{ This demo also shows how to use background image.                            }
{ srv.RichViewEdit.BackgroundBitmap is assigned to some image, and                    }
{ srv.RichViewEdit.BackgroundStyle is set to bsTiled                                  }
{==============================================================================}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVScroll, RichView, RVStyle, ExtCtrls, StdCtrls, SclRView;

type
  TForm1 = class(TForm)
    RVStyle1: TRVStyle;
    srv: TSRichViewEdit;
    Panel1: TPanel;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var ico: TIcon;
    bmp: TBitmap;
begin
  srv.SetMargin(5, 5, 5, 5);

  srv.RichViewEdit.Clear;
  srv.RichViewEdit.AddNL('Example of adding images', 1, 1);

  // Adding "break" - horizontal line
  srv.RichViewEdit.AddBreak;

  srv.RichViewEdit.AddNL('Adding icon:', 0, 0);
  // RichView frees inserted graphics when needed.
  // So srv.RichViewEdit.AddPictureEx('', Image1.Picture.Graphic, -1, rvvaBaseline)
  // will cause error. So we need to create copy of graphics.

  ico := TIcon.Create;
  ico.Assign(Image1.Picture.Graphic);
  srv.RichViewEdit.AddPictureEx('', ico, -1, rvvaBaseline);

  srv.RichViewEdit.AddNL('Adding bitmap:', 0, 0);

  // Adding bitmap from file:
  bmp := TBitmap.Create;
  bmp.LoadFromFile(ExtractFilePath(Application.ExeName)+'bars.bmp');
  srv.RichViewEdit.AddPictureEx('', bmp, -1, rvvaMiddle);

  srv.RichViewEdit.AddBreak;

  srv.RichViewEdit.Format;
  srv.RefreshData;

  // About AddPictureEx:
  // 1st parameter: name of picture. Allows to store additional text information
  //  together with image. There is no predefined meaning of this
  //  parameter. May be in future this string will be shown as a hint.
  // 2nd parameter: image. TBitmap, TIcon, TMetafile, etc.
  // 3rd parameter: index of paragraph style (-1 to continue paragraph)
  // 4th parameter: vertical align of image.
end;

end.
